IF EXISTS
(
    SELECT *
    FROM   INFORMATION_SCHEMA.TABLE_CONSTRAINTS
    WHERE  CONSTRAINT_TYPE = 'PRIMARY KEY'
		 AND TABLE_NAME = 'PG_DEB_PAGFOR_CONTROLE'
		 AND TABLE_SCHEMA = 'dbo'
)
    BEGIN
		ALTER TABLE [dbo].[PG_DEB_PAGFOR_RETORNO] 
			DROP CONSTRAINT [FK_PG_DEB_PAGFOR_RETORNO_PG_DEB_PAGFOR_CONTROLE]

		ALTER TABLE [dbo].[PG_DEB_PAGFOR_CONTROLE]
			DROP CONSTRAINT [PK_PG_DEB_PAGFOR_CONTROLE]
			
		ALTER TABLE [dbo].[PG_DEB_PAGFOR_CONTROLE]
			ADD CONSTRAINT [PK_PG_DEB_PAGFOR_CONTROLE] PRIMARY KEY CLUSTERED(
			   [CD_EMP] ASC, 
			   [CD_BC] ASC,
			   [CD_FILIAL] ASC, 
			   [NR_ARQUIVO] ASC, 
			   [CD_PG_CRED] ASC, 
			   [CD_CNT] ASC
			)
			WITH(PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY];
		
		ALTER TABLE [dbo].[PG_DEB_PAGFOR_RETORNO]  WITH NOCHECK ADD  CONSTRAINT [FK_PG_DEB_PAGFOR_RETORNO_PG_DEB_PAGFOR_CONTROLE] FOREIGN KEY([CD_EMP], [CD_BC], [CD_FILIAL], [NR_ARQUIVO], [CD_PG_CRED], [CD_CNT])
		REFERENCES [dbo].[PG_DEB_PAGFOR_CONTROLE] ([CD_EMP], [CD_BC], [CD_FILIAL], [NR_ARQUIVO], [CD_PG_CRED], [CD_CNT])
		ON UPDATE CASCADE

		ALTER TABLE [dbo].[PG_DEB_PAGFOR_RETORNO] CHECK CONSTRAINT [FK_PG_DEB_PAGFOR_RETORNO_PG_DEB_PAGFOR_CONTROLE]

END;
	
	